<?php


namespace App\Helpers;


class Helper
{
    public static function responseHelper($data,$code = 200,$messages = ["Request Completed Successfully"])
    {
        $response = [
            "response"=>[
                "code"=>$code,
                "messages"=>$code == 200?$messages:[],
                "data"=>$data
            ]
        ];
        if($code == 406){
            $response['error'] = ['messages'=>[]];
            $response['error']['messages'] = array_merge_recursive(...array_values($messages));
        }
        return response()->json($response);
    }

    //Distance Betweeen Two Points In Miles
    public static function haversineGreatCircleDistance(
        $latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
    {
        // convert from degrees to radians
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);

        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;

        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return $angle * $earthRadius;
    }

    //Send Email
    //sendEmail
    public static function sendEmail($to,$subject,$text){

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        // More headers
        $headers .= 'From: Work Addict <admin@workaddict.com>' . "\r\n";

        $message = "
                    <html>
                        <head>
                            <title>$subject</title>
                        </head>
                        <body>
                            <p>$text</p>
                            <p>Regards</p>
                            <p>Support Team</p>
                            <p>Work Addict</p>
                        </body>
                    </html>
                        ";

        $send =  @mail($to,$subject,$message,$headers);
        return true;

    }//sendEmail

}
