<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;

class AdminController extends Controller
{
    public function forgotPassword(Request $request){
        $admin = User::where('email',$request->email)->first();
        if($admin){

        }
        else{
            $request->session()->flash('Administrator Not Found');
        }
    }

    public function login(Request $request){
        $input = $request->only('email','password');
        if(Auth::attempt($input)){
            return redirect('/dashboard');
        }
        else{
            $request->session()->flash('error','Administrator Not Found');
            return redirect('/');
        }
    }

    public function dashboard(){
        return view('dashboard');
    }

    public function getUsers(){
        $users = User::where('is_admin',0)->get();
        return View::make('users')->with('users', $users);
    }

    public function getServices(){
        $services = Service::get();
        return View::make('services')->with('services',$services);
    }

    public function addService(Request $request){
        $service = new Service();
        $service->service_name = $request->service_name;
        $service->service_image = "service_placeholder.jpg";
        $service->save();
        return response()->json(['success'=>true,'message'=>'Service Added Successfully']);
    }

    public function editService(Request $request){
        Service::where('id',$request->id)->update([
            'service_name'=>$request->service_name
        ]);
        return response()->json(['success'=>true,'message'=>'Service Edited Successfully']);
    }

    public function logout(){
        Auth::logout();
        return redirect('/');
    }
}
