<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Http\Requests\LoginRequest;
use App\Http\Requests\RegisterRequest;
use App\Models\Business;
use App\Models\BusinessPicture;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Tymon\JWTAuth\JWTAuth;

class AuthController extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('auth:api', ['except' => ['login', 'register']]);
    }

    /**
     * Get a JWT via given credentials.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function login(LoginRequest $request){

        $credentials = $request->only('email', 'password');
        if (! $token = auth('api')->attempt($credentials)) {
            return Helper::responseHelper([],406,[["Invalid Credentials"]]);
        }
        return $this->createNewToken($token);
    }

    /**
     * Register a User.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function register(RegisterRequest $request) {
        $user = new User();
        $user->name = $request['name'];
        $user->email = $request['email'];
        $user->password = bcrypt($request['password']);
        $user->postal_code = $request['postal_code'];
        $user->udid = $request['udid'];
        $user->device_type = $request['device_type'];
        $user->device_token = $request['device_token'];
        $user->is_business = $request['is_business'];
        $user->save();
        if($request['is_business']==="1"){
            $business = new Business();
            $business->user_id = $user->id;
            $business->service_id = $request['service_id'];
            if($request->hasFile('cover_photo')) {
                $cover_photo = $request->file('cover_photo');
                $extension = $cover_photo->getClientOriginalExtension();
                $timestamp = strtotime(now());
                $destinationPath = storage_path("app/businesses/pictures");
                $cover_photo->move($destinationPath, $timestamp . "." . $extension);
                $business->cover_photo = $timestamp . "." . $extension;
            }
            $business->about = $request['about'];
            if($request->hasFile('video')) {
                $video = $request->file('video');
//                $extension = $video->getClientOriginalExtension();
                $extension = $request->video_type;
                $timestamp = strtotime(now());
                $destinationPath = storage_path("app/businesses/videos");
                $video->move($destinationPath, $timestamp . "." . $extension);
                $business->video = $timestamp . "." . $extension;
            }
            $latlong=$this->getLnt($request['postal_code']);
            $business->latitude = $latlong['lat'];
            $business->longitude = $latlong['lng'];
            $business->specializing = $request['specializing'];
            $business->save();
            for($i = 1; $i <= 10; $i++){
                $current = $request->file('image_'.$i);
                if($current){
                    $picture = $current;
//                    $extension = $picture->getClientOriginalExtension();
                    $extension = "png";
                    $random_number = $this->generateRandomString();
                    $timestamp = strtotime(now());
                    $destinationPath = storage_path("app/businesses/pictures");
                    $picture->move($destinationPath, $random_number.$timestamp . "." . $extension);
                    BusinessPicture::create([
                        'business_id'=>$business->id,
                        'image'=>$random_number.$timestamp. "." . $extension
                    ]);
                }
            }
            $credentials = $request->only('email', 'password');
            $token = auth('api')->attempt($credentials);
            return $this->createNewToken($token);
        }
        $credentials = $request->only('email', 'password');
        $token = auth('api')->attempt($credentials);
        return $this->createNewToken($token);
//        return Helper::responseHelper([
//            'user' => User::where('id',$user->id)->first()
//        ]);
    }


    /**
     * Log the user out (Invalidate the token).
     *
     * @return JsonResponse
     */
    public function logout() {
        auth()->logout();
        return response()->json(
            [
                'response' => [
                    'code'=>'200',
                    'messages'=>[
                        'Logged Out Successfully'
                    ],
                    'data'=>[],
                    'errors'=>[]
                ],
            ],200
        );
    }

    /**
     * Refresh a token.
     *
     * @return JsonResponse
     */
    public function refresh() {
        return $this->createNewToken(auth()->refresh());
    }

    /**
     * Get the authenticated User.
     *
     * @return JsonResponse
     */
    public function userProfile() {
        $user = auth('api')->user();
        if($user->is_business===1){
            return Helper::responseHelper([User::where('id',$user->id)->with(['business.businesspictures'])->first()]);
        }
        return Helper::responseHelper([auth()->user()]);
    }

    /**
     * Get the token array structure.
     *
     * @param string $token
     *
     * @return JsonResponse
     */
    protected function createNewToken(string $token){
        if(auth('api')->user()->is_business===1){
            $user = User::where('id',auth('api')->user()->id)->with('business.service')->first();
            $user->token = $token;
            return Helper::responseHelper([
                'token_type' => 'bearer',
                'expires_in' => auth('api')->factory()->getTTL() * 60,
                'user' => $user
            ]);

        }
        $user = User::where('id',auth('api')->user()->id)->first();
        $user->token = $token;
        return Helper::responseHelper([
            'token_type' => 'bearer',
            'expires_in' => auth('api')->factory()->getTTL() * 60,
            'user' => $user
        ]);
    }

    function generateRandomString($length = 6) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function getLnt($zip){
        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($zip)."&sensor=false&key=AIzaSyClS0RUrk3JDJ6nCksNC_2hd2SNQYpGa9A";
        $result_string = file_get_contents($url);
        $result = json_decode($result_string, true);
        return $result['results'][0]['geometry']['location'];
    }


}
