<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\Business;
use App\Models\BusinessPicture;
use App\Models\Chat;
use App\Models\Favorite;
use App\Models\Filter;
use App\Models\Notification;
use App\Models\Requests;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Symfony\Component\Console\Input\Input;
use LaravelFCM\Message\OptionsBuilder;
use LaravelFCM\Message\PayloadDataBuilder;
use LaravelFCM\Message\PayloadNotificationBuilder;
use FCM;

class BusinessController extends Controller
{
    public function getBusinesses(Request $request){
        if(auth('api')->user()){
            if(auth('api')->user()->is_business===1){
                $user = User::where('id',auth('api')->user()->id)->with('business')->first();
                $businesses = Business::whereNotIn('id',[$user->business->id])->with(['user','review','service'])->paginate(10);
                return Helper::responseHelper([$businesses]);
            }
        }
        $businesses = Business::with(['user','review','service'])->paginate(10);
        return Helper::responseHelper([$businesses]);
    }

    public function getBusiness($id){
        $business = Business::where('id',$id)->with(
            [
                'user',
                'service',
                'review.user',
                'businesspictures',
                'businessspecialization',
                'favorites'
            ]
        )->first();
        return Helper::responseHelper([$business]);
    }

    public function favoriteBusiness(Request $request){
        $user = auth('api')->user();
        if($request->mark==="0"){
            Favorite::where('business_id',$request->business_id)->where('user_id',$user->id)->delete();
            Notification::where('user_id',$user->id)->where('business_id',$request->business_id)->delete();
            return Helper::responseHelper([],200,[['Business Successfully Removed From Your Favorites']]);
        }
        else{
            $favorite = new Favorite();
            $favorite->user_id = $user->id;
            $favorite->business_id = $request->business_id;
            $favorite->save();
            return Helper::responseHelper([],200,[['Business Added To Favorites']]);
        }
    }

    public function sendRequest(Request $request){
        $user = auth('api')->user();
        $requests = Requests::where('user_id',$user->id)->where('business_id',$request->business_id)->first();
        if(!$requests) {
            $businessRequest = new Requests();
            $businessRequest->user_id = $user->id;
            $businessRequest->business_id = $request->business_id;



            $latlong = $this->getLnt($request['post_code']);
            if ($latlong['status'] === "ZERO_RESULTS") {
                return Helper::responseHelper([], 406, [['Please Enter A Valid Post Code']]);
            }
            if (isset($latlong['results'][0]['geometry']['location'])) {
                $latlong = $latlong['results'][0]['geometry']['location'];
            }
            $businessRequest->post_code = $request->post_code;
            $businessRequest->latitude = $latlong['lat'];
            $businessRequest->longitude = $latlong['lng'];
            $businessRequest->message = $request->message;
            $businessRequest->save();
            $notification = new Notification();
            $notification->from_id = auth('api')->user()->id;
            $business = Business::where('id',$request->business_id)->first();
            $notification->to_id = $business->user_id;
            $notification->title = auth('api')->user()->name." Sent A Message Request";
            $notification->request_id = $businessRequest->id;
            $notification->save();
            return Helper::responseHelper([$businessRequest], 200,[['Request Sent Successfully']]);
        }
        return Helper::responseHelper([], 406,[['Request Already Sent']]);
    }

    public function filterBusiness(Request $request)
    {
        if (auth('api')->user()) {
            if ($request->has('post_code')) {
                $latlong = $this->getLnt($request['post_code']);
                if ($latlong['status'] === "ZERO_RESULTS") {
                    return Helper::responseHelper([], 406, [['Please Enter A Valid Post Code']]);
                }
                if (isset($latlong['results'][0]['geometry']['location'])) {
                    $latlong = $latlong['results'][0]['geometry']['location'];
                }
                $latitude = $latlong['lat'];
                $longitude = $latlong['lng'];

                $haversine = "(3959 * acos(cos(radians(" . $latitude . "))
                    * cos(radians(`latitude`))
                    * cos(radians(`longitude`)
                    - radians(" . $longitude . "))
                    + sin(radians(" . $latitude . "))
                    * sin(radians(" . $latitude . "))))";
                $business = Business::whereRaw($haversine . '<=' . $request->radius)->select(DB::raw("*, $haversine AS distance"))->get();

            }
            $businessfilters = Filter::where('user_id', auth('api')->user()->id)->first();
            if($businessfilters){
                $businessfilters->service_ids = $request['service_ids'];
                $businessfilters->post_code = $request['post_code'];
                $businessfilters->radius = $request['radius'];
                $businessfilters->location_text = $request['location_text'];
                $businessfilters->by_rating = $request['by_rating'];
                $businessfilters->save();
            }
            else{
                $businessfilter = new Filter();
                $businessfilter->user_id = auth('api')->user()->id;
                $businessfilter->service_ids = $request['service_ids'];
                $businessfilter->post_code = $request['post_code'];
                $businessfilter->radius = $request['radius'];
                $businessfilter->location_text = $request['location_text'];
                $businessfilter->by_rating = $request['by_rating'];
                $businessfilter->save();
            }
        }
        $business = Business::with(['user', 'review', 'service'])->orderBy('')->get();
        return Helper::responseHelper([$business]);

//        if (auth('api')->user()) {
//            if ($request->has('post_code')) {
//                $latlong = $this->getLnt($request->post_code);
//                if ($latlong['status'] === "ZERO_RESULTS") {
//                    return Helper::responseHelper([], 406, [['Please Enter A Valid Post Code']]);
//                }
//                if (isset($latlong['results'][0]['geometry']['location'])) {
//                    $latlong = $latlong['results'][0]['geometry']['location'];
//                }
//                $latitude = $latlong['lat'];
//                $longitude = $latlong['lng'];
//                User::where('id', auth('api')->user()->id)->update(['postal_code' => $request['post_code']]);
//
//                $haversine = "(3959 * acos(cos(radians(" . $latitude . "))
//                    * cos(radians(`latitude`))
//                    * cos(radians(`longitude`)
//                    - radians(" . $longitude . "))
//                    + sin(radians(" . $latitude . "))
//                    * sin(radians(" . $latitude . "))))";
//                $business = Business::with(['user', 'review', 'service'])->whereRaw($haversine . '<=' . $request->radius)->select(DB::raw("*, $haversine AS distance"))->get();
//                return Helper::responseHelper([$business]);
//            } else {
//                $business = Business::with(['user', 'review', 'service'])->get();
//                return Helper::responseHelper([$business]);
//            }
//        }
    }


    //Get Lat Long From Post Code
    public function getLnt($zip){
        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($zip)."&sensor=false&key=AIzaSyClS0RUrk3JDJ6nCksNC_2hd2SNQYpGa9A";
        $result_string = file_get_contents($url);
        $result = json_decode($result_string, true);
        return $result;

    }

    public function editBusiness(Request $request){
        $business = Business::find($request->business_id);
        $business->service_id = $request->service_id;
        if($request->hasFile('cover_photo')) {
            $cover_photo = $request->file('cover_photo');
            $extension = $cover_photo->getClientOriginalExtension();
            $timestamp = strtotime(now());
            $destinationPath = storage_path("app/businesses/pictures");
            $cover_photo->move($destinationPath, $timestamp . "." . $extension);
            $business->cover_photo = $timestamp . "." . $extension;
        }
        if($request->has('about')) {
            $business->about = $request['about'];
        }
        if($request->hasFile('video')) {
            $video = $request->file('video');
//            $extension = $video->getClientOriginalExtension();
            $extension = $request->video_type;
            $timestamp = strtotime(now());
            $destinationPath = storage_path("app/businesses/videos");
            $video->move($destinationPath, $timestamp . "." . $extension);
            $business->video = $timestamp . "." . $extension;
        }
        if($request->has('postal_code')) {
            $latlong = $this->getLnt($request['postal_code']);
            if ($latlong['status'] === "ZERO_RESULTS") {
                return Helper::responseHelper([], 406, [['Please Enter A Valid Post Code']]);
            }
            if (isset($latlong['results'][0]['geometry']['location'])) {
                $latlong = $latlong['results'][0]['geometry']['location'];
            }
            $business->latitude = $latlong['lat'];
            $business->longitude = $latlong['lng'];
            User::where('id',$business->user_id)->update(['postal_code'=>$request['postal_code']]);
        }
        if($request->has('specializing')){
            $business->specializing = $request['specializing'];
        }
        $business_pictures = BusinessPicture::where('business_id',$request->business_id)->get()->toArray();
        for($i = 1; $i <= 10; $i++) {

            if ($request->hasFile('image_' . $i)) {
                $current = $request->file('image_' . $i);
                if ($current) {
                    $picture = $current;
                    if(isset($business_pictures[$i-1]['id'])){
                        BusinessPicture::findOrFail($business_pictures[$i-1]['id'])->delete();
                    }
//              $extension = $picture->getClientOriginalExtension();
                    $extension = "png";
                    $random_number = $this->generateRandomString();
                    $timestamp = strtotime(now());
                    $destinationPath = storage_path("app/businesses/pictures");
                    $picture->move($destinationPath, $random_number . $timestamp . "." . $extension);
                    BusinessPicture::create([
                        'business_id' => $business->id,
                        'image' => $random_number . $timestamp . "." . $extension
                    ]);
                    Log::debug($request);
                }
            }
        }

        $business->save();
        $user = User::where('id',$business->user_id)->with('business.businesspictures')->first();
        return Helper::responseHelper([$user],200,[['Business Updated Successfully']]);
    }

    public function viewRequest($id){
        $request = Requests::where('id',$id)->with(['user','business'])->first();
        return Helper::responseHelper([$request],200,[]);
    }

    public function blockUser($id){
        $user = User::where('id',auth('api')->user()->id)->with('business')->first();
        Requests::where('user_id',$id)->where('business_id',$user->business->id)->update([
            'is_blocked'=>1
        ]);
        Chat::where('to_id',$id)->where('from_id',$user->id)->update([
            'is_blocked'=>1
        ]);
        Chat::where('from_id',$id)->where('to_id',$user->id)->update([
            'is_blocked'=>1
        ]);

        return Helper::responseHelper([],200,[["User Blocked Successfully"]]);
    }

    public function blockBusiness($id){
        Requests::where('business_id',$id)->where('user_id',auth('api')->user()->id)
            ->update([
                'is_blocked'=>1
            ]);
        return Helper::responseHelper([],200,[["Business Blocked Successfully"]]);
    }


    public function acceptRequest(Request $request){
        $user = auth('api')->user();
//        $business = Business::where('id',$user->business->id)->first();
        $requests = Requests::where('id',$request->request_id)->first();
        $requests->is_accepted = 1;
        $requests->save();
        $chat = new Chat();
        $chat->from_id = $requests->user_id;
        $chat->to_id = $user->id;
        $chat->message = $requests->message;
        $chat->save();
        return Helper::responseHelper([],200,[["Request Sent Successfully"]]);
    }
    public function sendMessage(Request $request){
        $user = auth('api')->user();
        $chat = new Chat();
        $chat->from_id = $user->id;
        $chat->to_id = $request->to_id;
        if($request->hasFile('image')) {
            $cover_photo = $request->file('image');
            $extension = "png";
            $timestamp = strtotime(now());
            $destinationPath = storage_path("app/chats/pictures");
            $cover_photo->move($destinationPath, $timestamp . "." . $extension);
//                    $business->cover_photo = $timestamp . "." . $extension;
            $chat->image = "http://workaddict.dev-cmolds.com/storage/app/chats/pictures/".$timestamp.".".$extension;
        }
        $chat->message = $request->message;
        $chat->save();
        $optionBuilder = new OptionsBuilder();
        $optionBuilder->setTimeToLive(60*20);

        $notificationBuilder = new PayloadNotificationBuilder('Message From '.$user->name);
        $notificationBuilder->setBody('Message From '.$user->name)
            ->setSound('default');

        $dataBuilder = new PayloadDataBuilder();
        $dataBuilder->addData(['chat' => $chat]);

        $option = $optionBuilder->build();
        $notification = $notificationBuilder->build();
        $data = $dataBuilder->build();

        $token = [$user->device_token];

        $downstreamResponse = FCM::sendTo($token, $option, $notification, $data);

        $downstreamResponse->numberSuccess();
        $downstreamResponse->numberFailure();
        $downstreamResponse->numberModification();

// return Array - you must remove all this tokens in your database
        $downstreamResponse->tokensToDelete();

// return Array (key : oldToken, value : new token - you must change the token in your database)
        $downstreamResponse->tokensToModify();

// return Array - you should try to resend the message to the tokens in the array
        $downstreamResponse->tokensToRetry();

// return Array (key:token, value:error) - in production you should remove from your database the tokens
        $downstreamResponse->tokensWithError();
        return Helper::responseHelper([], 200, [['Message Sent Successfully']]);
    }

    public function searchBusiness($term){
        $businesses = Business::where('about','LIKE','%'.$term.'%')->with(['user','review'])->paginate(10);
        return response()->json(['success'=>true,'businesses'=>$businesses],200);
    }

    public function favoriteList(){
        $user = auth('api')->user();
        $favorites = Favorite::where('user_id',$user->id)->pluck('business_id')->toArray();
        $businesses = Business::with('service')->findMany($favorites);
        return Helper::responseHelper($businesses);
    }

    function generateRandomString($length = 6) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function getMessages(Request $request){
//        $messages = DB::table('chats')
//            ->select('chats.*','from.id as from_id','from.name as from_name','from.profile_picture as from_profile_picturfrom_profile_picturee','to.id as to_id','to.name as to_name','to.profile_picture as to_profile_picture')
//            ->orderBy('chats.id','desc')
//            ->join('users as to','to.id','=','chats.to_id')
//            ->join('users as from','from.id','=','chats.from_id')
////            ->groupBy(['chats.from_id','chats.to_id'])
//            ->paginate(10);
//        $messages = $messages->unique(['chats.from_id','chats.to_id']);
//        dd($messages);
//        $messages = Chat::where('from_id',auth('api')->user()->id)->orWhere('to_id',auth('api')->user()->id)->with(['sender','reciever'])->orderBy('created_at','DESC')->groupBy('from_id')->get();
//        $messages = Chat::where('from_id', auth('api')->user()->id)
//            ->orWhere('to_id',auth('api')->user()->id)
//            ->with(['sender','reciever'])
//            ->latest()
//            ->groupBy(['from_id'])
//            ->groupBy(['to_id'])
//            ->paginate(10);
        $id = auth('api')->user()->id;
        $messages = DB::select('
        SELECT t1.*,u.*,b.*,b.id as business_id
        FROM chats AS t1
        INNER JOIN users AS u on u.id=t1.to_id
        INNER JOIN businesses AS b on b.user_id=t1.to_id

        INNER JOIN
        (
            SELECT
                LEAST(from_id, to_id) AS sender_id,
                GREATEST(from_id, to_id) AS receiver_id,
                MAX(id) AS max_id
            FROM chats
            GROUP BY
                LEAST(sender_id, receiver_id),
                GREATEST(sender_id, receiver_id)
        ) AS t2
            ON LEAST(t1.from_id, t1.to_id) = t2.sender_id AND
               GREATEST(t1.from_id, t1.to_id) = t2.receiver_id AND
               t1.id = t2.max_id
            WHERE t1.to_id = ? OR t1.from_id = ?
        ', [$id, $id]);
//        $messages = $this->arrayPaginator($messages, $request);
        $collect = collect($messages);
        $page = 1;
        $size = 10;
        $paginationData = new LengthAwarePaginator(
            $collect->forPage($page, $size),
            $collect->count(),
            $size,
            $page
        );
        return Helper::responseHelper($paginationData);
    }

    public function arrayPaginator($array, $request)
    {
        $page = Input::get('page', 1);
        $perPage = 10;
        $offset = ($page * $perPage) - $perPage;

        return new LengthAwarePaginator(array_slice($array, $offset, $perPage, true), count($array), $perPage, $page,
            ['path' => $request->url(), 'query' => $request->query()]);
    }

    public function getNotifications(Request $request){
        $notifications = Notification::where('to_id',auth('api')->user()->id)->with(['to','from','request','review'])->orderBy('id','desc')->paginate(10);
        return Helper::responseHelper([$notifications]);
    }

    public function getchatmessages(Request $request){
        $chats = Chat::where('from_id',$request->from_id)->where('to_id',$request->to_id)->orWhere('to_id',$request->from_id)->orWhere('from_id',$request->to_id)->with(['sender','reciever'])->get();
        $business = Business::where('user_id',$request->to_id)->get();
        return Helper::responseHelper(['chats'=>$chats,'business'=>$business]);
    }

    public function portfoliolist($id){
        $businesspictures = BusinessPicture::where('business_id',$id)->get();
        return Helper::responseHelper([$businesspictures]);
    }
}
