<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\EditProfileRequest;
use App\Models\Business;
use App\Models\BusinessPicture;
use App\Models\Filter;
use App\Models\Notification;
use App\Models\Review;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Hash;
use LaravelFCM\Message\OptionsBuilder;
use LaravelFCM\Message\PayloadDataBuilder;
use LaravelFCM\Message\PayloadNotificationBuilder;
use FCM;

class UserController extends Controller
{
    public function rateBusiness(Request $request){
        $user = auth('api')->user();
        $rating = new Review();
        $rating->user_id = $user->id;
        $business = Business::where('id',$request->business_id)->first();
        $rating->business_id = $business->id;
        $rating->stars = $request->stars;
        $rating->review_message = $request->review_message;
        $rating->save();
        $notification = new Notification();
        $notification->from_id = $user->id;
        $notification->to_id = $business->user_id;
        $notification->title = $user->name." Mark A Star Rating";
        $notification->review_id = $rating->id;
        $notification->save();

        //Send Notification
        $optionBuilder = new OptionsBuilder();
        $optionBuilder->setTimeToLive(60*20);

        $notificationBuilder = new PayloadNotificationBuilder($user->name." Mark A Star Rating");
        $notificationBuilder->setBody($user->name." Mark A Star Rating")
            ->setSound('default');

        $dataBuilder = new PayloadDataBuilder();
        $dataBuilder->addData(['rating' => $rating]);

        $option = $optionBuilder->build();
        $notification = $notificationBuilder->build();
        $data = $dataBuilder->build();

        $notifyuser = User::where('id',$business->user_id)->first();
        $token = [$notifyuser->device_token];

        $downstreamResponse = FCM::sendTo($token, $option, $notification, $data);

        $downstreamResponse->numberSuccess();
        $downstreamResponse->numberFailure();
        $downstreamResponse->numberModification();

// return Array - you must remove all this tokens in your database
        $downstreamResponse->tokensToDelete();

// return Array (key : oldToken, value : new token - you must change the token in your database)
        $downstreamResponse->tokensToModify();

// return Array - you should try to resend the message to the tokens in the array
        $downstreamResponse->tokensToRetry();

// return Array (key:token, value:error) - in production you should remove from your database the tokens
        $downstreamResponse->tokensWithError();
        return Helper::responseHelper([],200,['Review Posted Successfully']);
    }

    public function editProfile(EditProfileRequest $request){
        $user = auth('api')->user();
        $user = User::find($user->id);
        $user->name = $request->name;
        $user->postal_code = $request->postcode;
        if($request->has('email')) {
            $user->email = $request->email;
        }
        if($request->has('profile_image')){
            $cover_photo = $request->file('profile_image');
            $extension = "png";
            $timestamp = strtotime(now());
            $destinationPath = storage_path("app/users/pictures");
            $cover_photo->move($destinationPath, $timestamp . "." . $extension);
            $user->profile_picture = $timestamp . "." . $extension;
        }
        $user->address = $request->address;
        $user->save();
        return Helper::responseHelper([$user],200,['Profile Updated Successfully']);
    }

    public function changePassword(ChangePasswordRequest $request){
        $user = auth('api')->user();
        $old = $request->input('current_password');
        $new = $request->input('new_password');
        if(Hash::check($old,$user->password)){
            $user->password = bcrypt($new);
            $user->save();
            return Helper::responseHelper([],200,["Password updated successfully"]);
        }else{
            return Helper::responseHelper([],406,[["Current password is incorrect"]]);
        }
    }

    public function getReviews($id){
        $reviews = Review::where('business_id',$id)->with(['user'])->paginate(10);
        return Helper::responseHelper([$reviews]);
    }

    public function createBusinessProfile(Request $request){
        $user = auth('api')->user();
        if($user->is_business===1){
            return Helper::responseHelper([],406,[["Business Profile Already Exists"]]);
        }
        else{
            $business = new Business();
//            $latlong=$this->getLnt($request['postal_code']);
//            $business->latitude = $latlong['lat'];
//            $business->longitude = $latlong['lng'];
            $business->specializing = $request['specializing'];
            $business->about = $request['about'];
            $business->service_id = $request['service_id'];
            $business->user_id = $user->id;
            if($request->hasFile('cover_photo')) {
                $cover_photo = $request->file('cover_photo');
//                $extension = $cover_photo->getClientOriginalExtension();
                $extension = "png";
                $timestamp = strtotime(now());
                $destinationPath = storage_path("app/businesses/pictures");
                $cover_photo->move($destinationPath, $timestamp . "." . $extension);
                $business->cover_photo = $timestamp . "." . $extension;
            }
            if($request->hasFile('video')) {
                $video = $request->file('video');
                //$extension = $video->getClientOriginalExtension();
                $extension = $request->video_type;
                $timestamp = strtotime(now());
                $destinationPath = storage_path("app/businesses/videos");
                $video->move($destinationPath, $timestamp . "." . $extension);
                $business->video = $timestamp . "." . $extension;
            }
            $business->save();
            for($i = 1; $i <= 10; $i++){
                if($request->hasFile('image_'.$i)) {
                    $current = $request->file('image_' . $i);
                    if ($current) {
                        $picture = $current;
                        $extension = "png";
                        $random_number = $this->generateRandomString();
                        $timestamp = strtotime(now());
                        $destinationPath = storage_path("app/businesses/pictures");
                        $picture->move($destinationPath, $random_number . $timestamp . "." . $extension);
                        BusinessPicture::create([
                            'business_id' => $business->id,
                            'image' => $random_number . $timestamp . "." . $extension,
                            'order' => $i
                        ]);
                    }
                }
            }
            User::where('id',auth('api')->user()->id)->update([
                'is_business'=>1
            ]);
            $user = User::where('id',auth('api')->user()->id)->with('business.service')->first();


            return Helper::responseHelper([$user],200,[["Business Profile Created Successfully"]]);
        }
    }

    function generateRandomString($length = 6) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    //Get Lat Long From Post Code
    public function getLnt($zip){
        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($zip)."&sensor=false&key=AIzaSyClS0RUrk3JDJ6nCksNC_2hd2SNQYpGa9A";
        $result_string = file_get_contents($url);
        $result = json_decode($result_string, true);
        return $result['results'][0]['geometry']['location'];
    }

    public function forgotpassword(Request $request){
        $user = User::where('email',$request->email)->first();
        if(!$user){
            return Helper::responseHelper([],406,[["Email Does Not Exists"]]);
        }
        $randomstring = $this->generateRandomString(8);
        $user->password = bcrypt($randomstring);
        $user->save();
        $text = "<h1>Dear User,<br>Your Temporary Password Is ".$randomstring."<br>Please Login Using This Temporary Password</h1>";
        Helper::sendEmail($request->email,'Forgot Password',$text);
        return Helper::responseHelper([],200,[["Password Reset Successful. Please Check Your Email."]]);
    }

    public function getUserFilters(){
        $businesFilter = Filter::where('user_id',auth('api')->user()->id)->first();
        if($businesFilter){
            return Helper::responseHelper([$businesFilter],200,[]);
        }
        else{
            return Helper::responseHelper([],406,[["No Businesses Found"]]);
        }

    }

    public function contactus(Request $request){
        return Helper::responseHelper([],200,[["Email Sent To Support Team Successfully"]]);
    }

    public function editUdid(Request $request){
        $user = User::where('id',auth('api')->user()->id)->first();
        $user->udid = $request->udid;
        $user->device_type = $request->device_type;
        $user->device_token = $request->device_token;
        $user->save();
        return Helper::responseHelper($user);
    }

    public function toggleNotifications(Request $request){
        $user = auth('api')->user();
        if($user->is_notifications_enabled===0){
            $user->is_notifications_enabled=1;
        }
        else{
            $user->is_notifications_enabled=0;
        }
        $user->save();
        return Helper::responseHelper($user,200,[["Notification Enabled Status Updated Successfully"]]);
    }
}
