<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use JWTAuth;

use Exception;

use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;

class JWTMiddleware extends BaseMiddleware

{

    /**

     * Handle an incoming request.

     *

     * @param \Illuminate\Http\Request $request

     * @param \Closure $next

     * @return mixed

     */

    public function handle($request, Closure $next)

    {

        try {

            $user = JWTAuth::parseToken()->authenticate();

            if( !$user ) throw new Exception('User Not Found');

        } catch (Exception $e) {

            if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenInvalidException){

                return response()->json([

                        'data' => null,

                        'status' => false,

                        'err_' => [

                            'message' => 'Token Invalid',

                            'code' => 1

                        ]

                    ]

                );

            }else if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenExpiredException){

                return response()->json([

                        'data' => null,

                        'status' => false,

                        'error' => [

                            'message' => 'Token Expired',

                            'code' =>1

                        ]

                    ]

                );

            }

            else{

                if( $e->getMessage() === 'User Not Found') {

                    return response()->json([

                            "data" => null,

                            "status" => false,

                            "error" => [

                                "message" => "User Not Found",

                                "code" => 1

                            ]

                        ]

                    ); }

                return response()->json([

                        'data' => null,

                        'status' => false,

                        'error' => [

                            'message' => 'Authorization Token not found',

                            'code' =>1

                        ]

                    ]

                );

            }

        }

        return $next($request);

    }

}
