<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use function PHPUnit\Framework\isNull;

class Business extends Model
{
    const BUSINESS_PICTURES_URL="http://workaddict.dev-cmolds.com/storage/app/businesses/pictures/";
    const BUSINESS_VIDEO_URL="http://workaddict.dev-cmolds.com/storage/app/businesses/videos/";
    use HasFactory;

    protected $table = 'businesses';

    protected $fillable = [
      'user_id',
      'service_id',
      'cover_photo',
      'specializing',
      'about',
      'video',
      'latitude',
      'longitude',
    ];

    protected $appends = [
        'isFavourite',
        'averageRating',
        'distance'
    ];
    public function getCoverPhotoAttribute($value){
        if($value) {
            return self::BUSINESS_PICTURES_URL . $value;
        }
    }

    public function getVideoAttribute($value){
        if($value) {
            return self::BUSINESS_VIDEO_URL . $value;
        }
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function review(){
        return $this->hasMany(Review::class,'business_id','id');
    }

    public function businesspictures(){
        return $this->hasMany(BusinessPicture::class);
    }

    public function businessspecialization(){
        return $this->hasMany(BusinessSpecialization::class,'business_id','id');
    }

    public function favorites(){
        return $this->hasMany(Favorite::class,'business_id','id');
    }

    public function service(){
        return $this->belongsTo(Service::class,'service_id','id');
    }

    public function getIsFavouriteAttribute()
    {
        $user = auth()->guard('api')->user();
        if (!isset($user)) return false;
        $wish = Favorite::where([['user_id','=',$user->id],['business_id','=',$this->id]])->first();
        if(isset($wish)) return true;
        return false;
    }

    public function getAverageRatingAttribute()
    {
        $rating = Review::where([['business_id','=',$this->id]])->avg('stars');
        if(!isset($rating)){
            return 0;
        }
        return $rating;
    }

    public function getDistanceAttribute()
    {
        $user = auth('api')->user();
//        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($user-postal_code)."&sensor=false&key=AIzaSyClS0RUrk3JDJ6nCksNC_2hd2SNQYpGa9A";
//        $result_string = file_get_contents($url);
//        $result = json_decode($result_string, true);
//        if ($result['status'] === "ZERO_RESULTS") {
//            return Helper::responseHelper([], 406, [['Please Enter A Valid Post Code']]);
//        }
//        if (isset($latlong['results'][0]['geometry']['location'])) {
//            $latlong = $latlong['results'][0]['geometry']['location'];
//        }
//        $haversine = "(3959 * acos(cos(radians(" . $latlong['lat'] . "))
//                    * cos(radians(`latitude`))
//                    * cos(radians(`longitude`)
//                    - radians(" . $longitude = $latlong['lng'] . "))
//                    + sin(radians(" . $latlong['lat'] . "))
//                    * sin(radians(" . $latlong['lat'] . "))))";
        return 3.2;
    }
}
