<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    use HasFactory;

    protected $fillable = [
      'from_id',
      'to_id',
      'message',
      'request_id',
      'image',
      'is_blocked'
    ];

    public function sender(){
        return $this->belongsTo(User::class,'from_id','id');
    }
    public function reciever(){
        return $this->belongsTo(User::class,'to_id','id');
    }

    public function request(){
        return $this->belongsTo(Requests::class,'request_id','id');
    }

}
