<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
      'to_id',
      'from_id',
      'title',
      'request_id',
      'review_id'
    ];

    public function to(){
        return $this->belongsTo(User::class,'to_id','id');
    }

    public function from(){
        return $this->belongsTo(User::class,'from_id','id');
    }

    public function request(){
        return $this->belongsTo(Requests::class,'request_id','id');
    }

    public function review(){
        return $this->belongsTo(Review::class,'review_id','id');
    }
}
