<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Requests extends Model
{
    use HasFactory;

    protected $fillable = [
      'user_id',
      'business_id',
      'post_code',
      'latitude',
      'longitude',
      'message',
      'is_blocked',
      'is_accepted'
    ];

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function business(){
        return $this->belongsTo(Business::class,'business_id','id');
    }
}
