<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'business_id',
        'stars',
        'review_message'
    ];

    protected $appends = [
        'averageRating',
    ];

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function business(){
        return $this->belongsTo(Business::class,'business_id','id');
    }

    public function getAverageRatingAttribute()
    {
        $rating = Review::where('id',$this->id)->avg('stars');
        return round($rating,2);
    }


}
