<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('postal_code')->nullable();
            $table->boolean('is_business')->default(0);
            $table->string('udid')->nullable();
            $table->string('device_type')->nullable();
            $table->string('device_token')->nullable();
            $table->boolean('is_admin')->default(0);
            $table->string('profile_picture')->nullable();
            $table->string('address')->nullable();
            $table->boolean('is_notifications_enabled')->default(1);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
