@include('layouts.header')
@include('layouts.navbar')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="container-fluid-full">
    <div class="row-fluid">

        <!-- start: Main Menu -->
        <div id="sidebar-left" class="span2">
            <div class="nav-collapse sidebar-nav">
                <ul class="nav nav-tabs nav-stacked main-menu">
                    <li><a href="{{url('/')}}"><i class="icon-bar-chart"></i><span class="hidden-tablet"> Dashboard</span></a></li>
                    <li><a href="{{url('users')}}"><i class="icon-user"></i><span class="hidden-tablet"> Users</span></a></li>
                    <li><a href="{{url('services')}}"><i class="icon-tasks"></i><span class="hidden-tablet"> Services</span></a></li>
                    <li><a href="{{url('logout')}}"><i class="icon-lock"></i><span class="hidden-tablet"> Logout</span></a></li>
                </ul>
            </div>
        </div>
        <!-- end: Main Menu -->

        <noscript>
            <div class="alert alert-block span10">
                <h4 class="alert-heading">Warning!</h4>
                <p>You need to have <a href="http://en.wikipedia.org/wiki/JavaScript" target="_blank">JavaScript</a> enabled to use this site.</p>
            </div>
        </noscript>

        <!-- start: Content -->
        <div id="content" class="span10" style="min-height: 279px;">
            <!--Datatables

            -->

            <div class="row-fluid sortable">
                <div class="box span12">
                    <div class="box-header" data-original-title>
                        <h2><i class="halflings-icon user"></i><span class="break"></span>Services</h2>
                        <div style="margin-top: -10px;" class="pull-right"><button data-toggle="modal" data-target="#addService" class="btn btn-primary">Add New Service</button></div>
                    </div>
                    <div class="box-content">
                        <table class="table table-striped table-bordered bootstrap-datatable datatable">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Image</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($services as $service)
                                <tr>
                                    <td>{{$service->service_name}}</td>
                                    <td class="center"><img src="{{asset('storage/app/services/')."/".$service->service_image}}"></td>
                                    <td class="center">
                                        <a class="btn btn-info editservicebtn" href="#" data-toggle="modal" data-target="#editservice" onclick="editService({{$service->id}},'{{$service->service_name}}')" data-name="{{$service->service_name}}" data-id="{{$service->id}}">
                                            <i class="halflings-icon white edit"></i>
                                        </a>
                                        <a class="btn btn-danger deleteservicebtn" href="#" data-id="{{$service->id}}">
                                            <i class="halflings-icon white trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div><!--/span-->

            </div><!--/row-->
        </div><!--/.fluid-container-->
        <div class="modal hide fade" id="editservice" aria-hidden="true" style="display: none;">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h3>Edit Service</h3>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <input type="text" style="display: none;" id="editserviceid">
                        <label>Service Name</label>
                        <input class="form-control" type="text" required id="editservicename" placeholder="Please Enter Service Name">
                    </div>
                    <div class="form-group">
                        <label>Service Image</label>
                        <input class="form-control" type="file" id="editserviceimage" accept="image/x-png,image/gif,image/jpeg" >
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Close</a>
                <a href="#" id="editservicesave" class="btn btn-primary">Save Service</a>
            </div>
        </div>
        <div class="modal hide fade" id="addService" aria-hidden="true" style="display: none;">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h3>Add New Service</h3>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label>Service Name</label>
                        <input class="form-control" type="text" required id="servicename" placeholder="Please Enter Service Name">
                    </div>
                    <div class="form-group">
                        <label>Service Image</label>
                        <input class="form-control" type="file" id="serviceimage" accept="image/x-png,image/gif,image/jpeg" >
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn" data-dismiss="modal">Close</a>
                <a href="#" id="saveservices" class="btn btn-primary">Save changes</a>
            </div>
        </div>
        <!-- end: Content -->
    </div><!--/#content.span10-->
</div>
@include('layouts.footer')
<script>
    function editService(id,name){
        $("#editservicename").val(name);
        $("#editserviceid").val(id);
    }
    $(document).ready(function (){
        $("#editservicesave").click(function (){
            var id = $("#editserviceid").val()
            var name = $("#editservicename").val();
            console.log(id);
            console.log(name);
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{url('editservice')}}",
                type: "post",
                data: {"service_name": name, "id":id} ,
                success: function (response) {
                    console.log(response);
                    window.location.reload();
                    // You will get response from your PHP page (what you echo or print)
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        });
        //AddNew Service
        $("#saveservices").click(function (){
            var service_name = $("#servicename").val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{url('addservice')}}",
                type: "post",
                data: {"service_name": service_name} ,
                success: function (response) {
                    console.log(response);
                    window.location.reload();
                    // You will get response from your PHP page (what you echo or print)
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        });
    });
</script>
