<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group([
    'middleware' => 'api',
    'prefix' => 'auth'

], function ($router) {
    Route::post('login', 'App\Http\Controllers\AuthController@login');
    Route::post('register', 'App\Http\Controllers\AuthController@register');
});


Route::group(['middleware' => 'jwt.verify'], static function($router){
    //Auth Routes
    Route::post('logout', 'App\Http\Controllers\AuthController@logout');
    Route::get('user-profile', 'App\Http\Controllers\AuthController@userProfile');
    Route::post('refresh', 'App\Http\Controllers\AuthController@refresh');

    Route::post('favoritebusiness','App\Http\Controllers\BusinessController@favoriteBusiness');

    //Chat
    Route::post('sendrequest','App\Http\Controllers\BusinessController@sendRequest');
    Route::get('viewrequest/{id}','App\Http\Controllers\BusinessController@viewRequest');
    Route::post('sendmessage','App\Http\Controllers\BusinessController@sendMessage');
    Route::get('blockuser/{id}','App\Http\Controllers\BusinessController@blockUser');
    Route::get('blockbusiness/{id}','App\Http\Controllers\BusinessController@blockBusiness');

    //Rate And Review
    Route::post('rate','App\Http\Controllers\UserController@rateBusiness');


    //Edit Profile
    Route::post('editprofile','App\Http\Controllers\UserController@editProfile');
    Route::post('changepassword','App\Http\Controllers\UserController@changePassword');
    Route::post('editbusiness','App\Http\Controllers\BusinessController@editBusiness');
    Route::post('createbusinessprofile','App\Http\Controllers\UserController@createBusinessProfile');

    //Get User Filter
    Route::get('get/user/filters','App\Http\Controllers\UserController@getUserFilters');

    //Get Favorites
    Route::get('get/favorites','App\Http\Controllers\BusinessController@favoriteList');

    Route::post('notifications','App\Http\Controllers\BusinessController@getNotifications');

    Route::post('getchats','App\Http\Controllers\BusinessController@getMessages');

    Route::post('getchatmessages','App\Http\Controllers\BusinessController@getchatmessages');

    Route::post('acceptrequest','App\Http\Controllers\BusinessController@acceptRequest');

    Route::post('editudid','App\Http\Controllers\UserController@editUdid');

    Route::post('togglenotifications','App\Http\Controllers\UserController@toggleNotifications');
});

//Services
Route::get('services','App\Http\Controllers\ServiceController@getServices');

//Businesses
Route::post('businesses','App\Http\Controllers\BusinessController@getBusinesses');
Route::get('searchbusiness/{term}','App\Http\Controllers\BusinessController@searchBusiness');
Route::get('business/{id}','App\Http\Controllers\BusinessController@getBusiness');
Route::post('filter/business','App\Http\Controllers\BusinessController@filterBusiness');

//Forgot Password
Route::post('forgot_password','App\Http\Controllers\UserController@forgotpassword');

//Content
Route::get('get/content/{type}','App\Http\Controllers\ContentController@getContent');

//Ratings
Route::get('get/ratings/{id}','App\Http\Controllers\UserController@getReviews');
Route::get('get/portfolio/{id}','App\Http\Controllers\BusinessController@portfoliolist');

Route::post('contactus','App\Http\Controllers\UserController@contactus');
